% Model of a nonisothermal batch reactor - Strongly exothermic reaction

% Function file

% For more information, see:

% A. De Visscher 
% Lecture Notes in Chemical Engineering Kinetics and Chemical Reactor Design
% Createspace (2013) 

% (C) Alex De Visscher (2013)

% ---------------------------

function dcdt = f(t,c,cA0,cB0,cC0,A,EA,V,Ac,U,Tc,DH0,Cpsum)

dcdt = zeros(2,1);     % Allocate space for the right-hand sides of the DEs

cA = c(1);                % Concentration of A
T = c(2);                 % Temperature
cB = cB0 - cA0 + cA;      % Concentration of B (from stoichiometry)
cC = cC0 + cA0 - cA;      % Concentration of C (from stoichiometry)

R = 8.314472;
k = A*exp(-EA/(R*T));     % Rate constant
r = k*cA*cB;              % Reaction rate

DH = DH0;
q = U*Ac*(Tc - T);

dcdt(1) = -r;             % Differential equation for concentration
dcdt(2) = (-V*r*DH + q)/(Cpsum*V);
